--
-- Real Mower for FS25
-- @author:    	kenny456 (kenny456@seznam.cz)
-- @history:	v1.0 - 2024-11-13 - conversion to FS25
-- 				v1.1 - 2025-10-09 - fixed LUA error when saving game
--								  - added function for mulchers and forestry mulchers
--
local modDirectory = g_currentModDirectory or ""
local modName = g_currentModName or "unknown"

source(modDirectory .. "realMower.lua")

local function initSpecialization(manager)
    if manager.typeName == "vehicle" then
        g_specializationManager:addSpecialization("realMower", "RealMower", modDirectory .. "realMower.lua", nil)

        for typeName, typeEntry in pairs(g_vehicleTypeManager:getTypes()) do
			if typeEntry ~= nil and typeName ~= "locomotive" and typeName ~= "trainTrailer" and typeName ~= "trainTimberTrailer" then 
				if SpecializationUtil.hasSpecialization(Mower, typeEntry.specializations) or SpecializationUtil.hasSpecialization(Mulcher, typeEntry.specializations) or (SpecializationUtil.hasSpecialization(StumpCutter, typeEntry.specializations) and SpecializationUtil.hasSpecialization(Plow, typeEntry.specializations) and SpecializationUtil.hasSpecialization(Cultivator, typeEntry.specializations)) then
					g_vehicleTypeManager:addSpecialization(typeName, modName .. ".realMower")
				end
            end
        end
    end
end

local function init()
    TypeManager.validateTypes = Utils.prependedFunction(TypeManager.validateTypes, initSpecialization)
end

init()